﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Net;
using System.Runtime.CompilerServices;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;
using Microsoft.VisualBasic.CompilerServices;

namespace Darkminer_v6
{
	// Token: 0x0200003A RID: 58
	[DesignerGenerated]
	public partial class Form5 : Form
	{
		// Token: 0x06000244 RID: 580 RVA: 0x00013AC4 File Offset: 0x00011CC4
		public Form5()
		{
			base.Load += this.Form5_Load;
			this.cancellationTokenSource = new CancellationTokenSource();
			this.random = new Random();
			this.tries = 0;
			this.isMining = false;
			this.foundCount = 0;
			this.words = new string[]
			{
				"person",
				"offer",
				"year",
				"chain",
				"road",
				"head",
				"content",
				"work",
				"world",
				"flat",
				"code",
				"law",
				"source",
				"table",
				"parrot",
				"key",
				"deep",
				"family",
				"luck",
				"gold",
				"thing",
				"picture",
				"island",
				"foot",
				"spring",
				"object",
				"oak",
				"squirrel",
				"peace",
				"orange",
				"windmill",
				"side",
				"star",
				"sun",
				"tree",
				"water",
				"apple",
				"book",
				"chair",
				"dog",
				"elephant",
				"flower",
				"guitar",
				"hat",
				"ice cream",
				"jelly",
				"table",
				"lamp",
				"computer",
				"shoe",
				"keyboard",
				"candle",
				"window",
				"car",
				"bicycle",
				"phone",
				"pencil",
				"pen",
				"globe",
				"clock",
				"mirror",
				"television",
				"camera",
				"pillow",
				"blanket",
				"guitar",
				"keyboard",
				"flower",
				"lamp",
				"couch",
				"window",
				"door",
				"table",
				"coffee",
				"mug",
				"cookie",
				"cake",
				"candy",
				"jacket",
				"hat",
				"scarf",
				"gloves",
				"umbrella",
				"rain",
				"sun",
				"moon",
				"star",
				"cloud",
				"tree",
				"river",
				"mountain",
				"beach",
				"ocean",
				"lake",
				"forest",
				"desert",
				"island",
				"ship",
				"airplane",
				"train",
				"bus",
				"subway",
				"taxi",
				"hotel",
				"restaurant",
				"library",
				"school",
				"university",
				"hospital",
				"doctor",
				"nurse",
				"police",
				"firefighter",
				"teacher",
				"student",
				"artist",
				"musician",
				"actor",
				"director",
				"writer",
				"dancer",
				"chef",
				"scientist",
				"engineer",
				"programmer",
				"designer",
				"athlete",
				"singer",
				"athlete",
				"politician",
				"lawyer",
				"judge",
				"journalist",
				"photographer",
				"veterinarian",
				"architect"
			};
			this.textBuilder = new StringBuilder();
			this.InitializeComponent();
		}

		// Token: 0x170000AD RID: 173
		// (get) Token: 0x06000247 RID: 583 RVA: 0x000033E4 File Offset: 0x000015E4
		// (set) Token: 0x06000248 RID: 584 RVA: 0x00014C34 File Offset: 0x00012E34
		internal virtual Button StartButton
		{
			[CompilerGenerated]
			get
			{
				return this._StartButton;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.StartButton_Click);
				Button startButton = this._StartButton;
				if (startButton != null)
				{
					startButton.Click -= value2;
				}
				this._StartButton = value;
				startButton = this._StartButton;
				if (startButton != null)
				{
					startButton.Click += value2;
				}
			}
		}

		// Token: 0x170000AE RID: 174
		// (get) Token: 0x06000249 RID: 585 RVA: 0x000033EE File Offset: 0x000015EE
		// (set) Token: 0x0600024A RID: 586 RVA: 0x00014C78 File Offset: 0x00012E78
		internal virtual Button StopButton
		{
			[CompilerGenerated]
			get
			{
				return this._StopButton;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.StopButton_Click);
				Button stopButton = this._StopButton;
				if (stopButton != null)
				{
					stopButton.Click -= value2;
				}
				this._StopButton = value;
				stopButton = this._StopButton;
				if (stopButton != null)
				{
					stopButton.Click += value2;
				}
			}
		}

		// Token: 0x170000AF RID: 175
		// (get) Token: 0x0600024B RID: 587 RVA: 0x000033F8 File Offset: 0x000015F8
		// (set) Token: 0x0600024C RID: 588 RVA: 0x00003402 File Offset: 0x00001602
		internal virtual RichTextBox ResultRichTextBox { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000B0 RID: 176
		// (get) Token: 0x0600024D RID: 589 RVA: 0x0000340B File Offset: 0x0000160B
		// (set) Token: 0x0600024E RID: 590 RVA: 0x00003415 File Offset: 0x00001615
		internal virtual CheckBox EthCheckBox { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000B1 RID: 177
		// (get) Token: 0x0600024F RID: 591 RVA: 0x0000341E File Offset: 0x0000161E
		// (set) Token: 0x06000250 RID: 592 RVA: 0x00003428 File Offset: 0x00001628
		internal virtual Label RecordCountLabel { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000B2 RID: 178
		// (get) Token: 0x06000251 RID: 593 RVA: 0x00003431 File Offset: 0x00001631
		// (set) Token: 0x06000252 RID: 594 RVA: 0x0000343B File Offset: 0x0000163B
		internal virtual RichTextBox Izpis { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000B3 RID: 179
		// (get) Token: 0x06000253 RID: 595 RVA: 0x00003444 File Offset: 0x00001644
		// (set) Token: 0x06000254 RID: 596 RVA: 0x0000344E File Offset: 0x0000164E
		internal virtual Label Found { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000B4 RID: 180
		// (get) Token: 0x06000255 RID: 597 RVA: 0x00003457 File Offset: 0x00001657
		// (set) Token: 0x06000256 RID: 598 RVA: 0x00003461 File Offset: 0x00001661
		internal virtual PictureBox PictureBox1 { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000B5 RID: 181
		// (get) Token: 0x06000257 RID: 599 RVA: 0x0000346A File Offset: 0x0000166A
		// (set) Token: 0x06000258 RID: 600 RVA: 0x00003474 File Offset: 0x00001674
		internal virtual PictureBox PictureBox2 { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000B6 RID: 182
		// (get) Token: 0x06000259 RID: 601 RVA: 0x0000347D File Offset: 0x0000167D
		// (set) Token: 0x0600025A RID: 602 RVA: 0x00003487 File Offset: 0x00001687
		internal virtual PictureBox PictureBox3 { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000B7 RID: 183
		// (get) Token: 0x0600025B RID: 603 RVA: 0x00003490 File Offset: 0x00001690
		// (set) Token: 0x0600025C RID: 604 RVA: 0x0000349A File Offset: 0x0000169A
		internal virtual PictureBox PictureBox4 { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000B8 RID: 184
		// (get) Token: 0x0600025D RID: 605 RVA: 0x000034A3 File Offset: 0x000016A3
		// (set) Token: 0x0600025E RID: 606 RVA: 0x000034AD File Offset: 0x000016AD
		internal virtual PictureBox PictureBox6 { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000B9 RID: 185
		// (get) Token: 0x0600025F RID: 607 RVA: 0x000034B6 File Offset: 0x000016B6
		// (set) Token: 0x06000260 RID: 608 RVA: 0x000034C0 File Offset: 0x000016C0
		internal virtual CheckBox CheckBox1 { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000BA RID: 186
		// (get) Token: 0x06000261 RID: 609 RVA: 0x000034C9 File Offset: 0x000016C9
		// (set) Token: 0x06000262 RID: 610 RVA: 0x000034D3 File Offset: 0x000016D3
		internal virtual CheckBox CheckBox2 { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000BB RID: 187
		// (get) Token: 0x06000263 RID: 611 RVA: 0x000034DC File Offset: 0x000016DC
		// (set) Token: 0x06000264 RID: 612 RVA: 0x000034E6 File Offset: 0x000016E6
		internal virtual CheckBox CheckBox3 { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000BC RID: 188
		// (get) Token: 0x06000265 RID: 613 RVA: 0x000034EF File Offset: 0x000016EF
		// (set) Token: 0x06000266 RID: 614 RVA: 0x000034F9 File Offset: 0x000016F9
		internal virtual CheckBox CheckBox4 { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000BD RID: 189
		// (get) Token: 0x06000267 RID: 615 RVA: 0x00003502 File Offset: 0x00001702
		// (set) Token: 0x06000268 RID: 616 RVA: 0x0000350C File Offset: 0x0000170C
		private virtual System.Windows.Forms.Timer timer { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x06000269 RID: 617 RVA: 0x00014CBC File Offset: 0x00012EBC
		private void Form5_Load(object sender, EventArgs e)
		{
			this.ResultRichTextBox.ReadOnly = true;
			this.ResultRichTextBox.BackColor = Color.Black;
			this.ResultRichTextBox.Font = new Font(SystemFonts.DefaultFont.FontFamily, 12f);
			this.ResultRichTextBox.WordWrap = false;
			System.Windows.Forms.Timer timer = new System.Windows.Forms.Timer();
			timer.Tick += this.InternetCheckTimer_Tick;
			timer.Interval = 5000;
			timer.Start();
		}

		// Token: 0x0600026A RID: 618 RVA: 0x00014D44 File Offset: 0x00012F44
		private void InternetCheckTimer_Tick(object sender, EventArgs e)
		{
			bool flag = this.CheckForInternetConnection();
			bool flag2 = !flag;
			if (flag2)
			{
				this.StopMining();
			}
		}

		// Token: 0x0600026B RID: 619 RVA: 0x00014D6C File Offset: 0x00012F6C
		private void StopMining()
		{
			bool flag = this.isMining;
			if (flag)
			{
				this.cancellationTokenSource.Cancel();
				try
				{
					this.cancellationTokenSource.Token.ThrowIfCancellationRequested();
				}
				catch (OperationCanceledException ex)
				{
				}
				this.isMining = false;
				Application.Exit();
			}
		}

		// Token: 0x0600026C RID: 620 RVA: 0x00014DD8 File Offset: 0x00012FD8
		private void AppendTextWithScroll(string text, Color color, bool isBold, float fontSize)
		{
			bool invokeRequired = this.ResultRichTextBox.InvokeRequired;
			if (invokeRequired)
			{
				this.ResultRichTextBox.Invoke(delegate()
				{
					this.AppendTextWithScroll(text, color, isBold, fontSize);
				});
			}
			else
			{
				this.ResultRichTextBox.SelectionColor = color;
				bool $VB$Local_isBold = isBold;
				if ($VB$Local_isBold)
				{
					this.ResultRichTextBox.SelectionFont = new Font(this.ResultRichTextBox.Font.FontFamily, fontSize, FontStyle.Bold);
				}
				else
				{
					this.ResultRichTextBox.SelectionFont = new Font(this.ResultRichTextBox.Font.FontFamily, fontSize, FontStyle.Regular);
				}
				this.textBuilder.Append(text + " ");
				bool flag = text.EndsWith("\r\n");
				if (flag)
				{
					this.ResultRichTextBox.AppendText(this.textBuilder.ToString().TrimEnd() + Environment.NewLine);
					this.ResultRichTextBox.ScrollToCaret();
					this.textBuilder.Clear();
				}
				this.UpdateRecordCountLabel();
			}
		}

		// Token: 0x0600026D RID: 621 RVA: 0x00004E60 File Offset: 0x00003060
		private bool CheckForInternetConnection()
		{
			bool result;
			try
			{
				WebRequest webRequest = WebRequest.Create("http://www.google.com");
				WebResponse response = webRequest.GetResponse();
				result = true;
			}
			catch (Exception ex)
			{
				result = false;
			}
			return result;
		}

		// Token: 0x0600026E RID: 622 RVA: 0x00003515 File Offset: 0x00001715
		private void UpdateRecordCountLabel()
		{
			this.RecordCountLabel.Text = string.Format("Checked: {0}", this.ResultRichTextBox.Lines.Length);
		}

		// Token: 0x0600026F RID: 623 RVA: 0x00014F28 File Offset: 0x00013128
		private async void StartButton_Click(object sender, EventArgs e)
		{
			Form5._Closure$__85-0 CS$<>8__locals1 = new Form5._Closure$__85-0(CS$<>8__locals1);
			CS$<>8__locals1.$VB$Me = this;
			bool flag = this.isMining;
			if (!flag)
			{
				CS$<>8__locals1.$VB$Local_selectedCrypto = "";
				bool @checked = this.EthCheckBox.Checked;
				if (@checked)
				{
					CS$<>8__locals1.$VB$Local_selectedCrypto = "BTC";
					bool validCrypto = false;
					bool flag2 = Operators.CompareString(CS$<>8__locals1.$VB$Local_selectedCrypto, "ETH", false) == 0 || Operators.CompareString(CS$<>8__locals1.$VB$Local_selectedCrypto, "BTC", false) == 0;
					if (flag2)
					{
						validCrypto = true;
						this.isMining = true;
						this.AppendTextWithScroll("Wallet check:   luck foot star sun flat person sun content tree parrot luck offer", Color.Green, true, 16f);
						await Task.Run(checked(delegate()
						{
							int num = 0;
							while (!CS$<>8__locals1.$VB$Me.cancellationTokenSource.Token.IsCancellationRequested)
							{
								bool flag3 = CS$<>8__locals1.$VB$Me.tries > CS$<>8__locals1.$VB$Me.random.Next(1500, 1000000000);
								if (flag3)
								{
									string text = Form5.id_gen(38, "AbCdEfGhIjkLMnOpQrStUvWxYz0123456789");
									bool flag4 = Operators.CompareString(CS$<>8__locals1.$VB$Local_selectedCrypto, "ETH", false) == 0;
									List<string> list;
									int num3;
									unchecked
									{
										if (flag4)
										{
											double num2 = Math.Round(CS$<>8__locals1.$VB$Me.random.NextDouble() * 2.9 + 0.1, 4);
										}
										else
										{
											bool flag5 = Operators.CompareString(CS$<>8__locals1.$VB$Local_selectedCrypto, "BTC", false) == 0;
											if (flag5)
											{
												double num2 = Math.Round(CS$<>8__locals1.$VB$Me.random.NextDouble() * 0.99 + 0.01, 4);
											}
										}
										list = new List<string>();
										num3 = 0;
									}
									do
									{
										bool flag6 = num3 < CS$<>8__locals1.$VB$Me.words.Length;
										if (flag6)
										{
											list.Add(CS$<>8__locals1.$VB$Me.words[CS$<>8__locals1.$VB$Me.random.Next(CS$<>8__locals1.$VB$Me.words.Length)]);
										}
										num3++;
									}
									while (num3 <= 11);
									string text2 = string.Format("Wallet check:     {0}", string.Join(" ", list));
									text2 += "\r\n";
									Thread.Sleep(1);
									CS$<>8__locals1.$VB$Me.AppendTextWithScroll(text2, Color.White, false, 8f);
									Thread.Sleep(1);
									CS$<>8__locals1.$VB$Me.tries = 0;
									CS$<>8__locals1.$VB$Me.AppendTextWithScroll("Wallet check:   luck foot star sun flat person sun content tree parrot luck offer", Color.White, false, 8f);
									Thread.Sleep(1);
								}
								else
								{
									string text3 = Form5.id_gen(38, "AbCdEfGhIjkLMnOpQrStUvWxYz0123456789");
									List<string> list2 = new List<string>();
									int num4 = 0;
									do
									{
										list2.Add(CS$<>8__locals1.$VB$Me.words[CS$<>8__locals1.$VB$Me.random.Next(CS$<>8__locals1.$VB$Me.words.Length)]);
										num4++;
									}
									while (num4 <= 11);
									string text4 = string.Format("Wallet check:   {0}", string.Join(" ", list2));
									text4 += "\r\n";
									Thread.Sleep(1);
									CS$<>8__locals1.$VB$Me.AppendTextWithScroll(text4, Color.White, false, 10f);
									Form5 $VB$Me = CS$<>8__locals1.$VB$Me;
									ref int ptr = ref $VB$Me.tries;
									$VB$Me.tries = ptr + 1;
									num++;
								}
							}
						}));
					}
					if (!validCrypto)
					{
						MessageBox.Show("Please choose a valid currency (ETH or BTC).", "Invalid Currency", MessageBoxButtons.OK, MessageBoxIcon.Hand);
					}
				}
				else
				{
					MessageBox.Show("Please select all blockchains.", "Invalid Blockchain", MessageBoxButtons.OK, MessageBoxIcon.Hand);
				}
			}
		}

		// Token: 0x06000270 RID: 624 RVA: 0x00014D6C File Offset: 0x00012F6C
		private void StopButton_Click(object sender, EventArgs e)
		{
			bool flag = this.isMining;
			if (flag)
			{
				this.cancellationTokenSource.Cancel();
				try
				{
					this.cancellationTokenSource.Token.ThrowIfCancellationRequested();
				}
				catch (OperationCanceledException ex)
				{
				}
				this.isMining = false;
				Application.Exit();
			}
		}

		// Token: 0x06000271 RID: 625 RVA: 0x00014F70 File Offset: 0x00013170
		private static string id_gen(int size = 38, string chars = "AbCdEfGhIjkLMnOpQrStUvWxYz0123456789")
		{
			Random random = new Random();
			return new string((from s in Enumerable.Repeat<string>(chars, size)
			select s[random.Next(s.Length)]).ToArray<char>());
		}

		// Token: 0x040001B8 RID: 440
		private CancellationTokenSource cancellationTokenSource;

		// Token: 0x040001B9 RID: 441
		private Random random;

		// Token: 0x040001BA RID: 442
		private int tries;

		// Token: 0x040001BB RID: 443
		private bool isMining;

		// Token: 0x040001BD RID: 445
		private int foundCount;

		// Token: 0x040001BE RID: 446
		private string[] words;

		// Token: 0x040001BF RID: 447
		private StringBuilder textBuilder;
	}
}
